/***************************************************************************
 *   Copyright (C) 2005 by Joe Ferris                                      *
 *   jferris@optimistictech.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef ACTIONREGISTRY_H
#define ACTIONREGISTRY_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tqptrlist.h>
#include <kdemacros.h>

class KatapultItem;
class KatapultAction;

/**
@author Joe Ferris
*/
class KDE_EXPORT ActionRegistry{
public:
	~ActionRegistry();
	
	void registerAction(const KatapultAction *);
	TQPtrList<KatapultAction> actionsForItem(const KatapultItem *) const;
	void clear();
	
	static ActionRegistry * self();
	
private:
	ActionRegistry();
	
	TQPtrList<KatapultAction> actions;

};

#endif
