//
// C++ Interface: kbfileinfo
//
// Description: 
//
//
// Author: Magnus Kulke <mkulke@magnusmachine>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KBFILEINFO_H
#define KBFILEINFO_H

#include <ntqfileinfo.h>

class KbItem;

/**
@author Magnus Kulke
*/
class KbFileInfo : public TQFileInfo
{
public:

	//KbFileInfo();
	KbFileInfo(TQFileInfo qfi);
	KbFileInfo(const KbFileInfo& kfi);
	KbFileInfo(TQString workingdir);
	KbFileInfo(KbItem* item, TQString workingdir);
	KbFileInfo(const TQString & d, const TQString & fileName, off64_t size, TQString date, unsigned int date_int);
	~KbFileInfo();
	off64_t Size() { return m_size; };
	TQString Date() { return m_date; };
	unsigned int DateInt() { return m_date_int; };
	void SetDirPath(TQString path); 
	void SetSize(off64_t size) { m_size = size; };
	static bool PrioritySort(KbFileInfo *f1, KbFileInfo *f2);
	//static bool PrioritySort(const KbFileInfo &f1, const KbFileInfo &f2);
private:
   off64_t m_size;
	unsigned int m_date_int;
	TQString m_date;
};

#endif
