/*
 * channeleditor.h
 *
 * Copyright (C) 2004-2005 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef CHANNELEDITOR_H
#define CHANNELEDITOR_H

#include <tqstringlist.h>

#include "channeleditorui.h"
#include "channeldesc.h"

class ChannelEditor : public ChannelEditorUI
{
	Q_OBJECT
  

public:

	ChannelEditor( TQStringList src, bool m, ChannelDesc *chan, TQPtrList<ChannelDesc> *cdesc, TQWidget *parent );
	~ChannelEditor();

protected:

	virtual void accept();

private slots:

	void editAudio();
	void editSubtitle();

private:

	void initS();
	void initC();
	void initT();
	void initA();
	TQStringList inversionList();
	TQStringList coderateList();
	TQStringList modulationList();
	TQStringList transmissionList();
	TQStringList bandwidthList();
	TQStringList hierarchyList();
	TQStringList guardList();
	TQStringList stypeList();
	TQStringList rolloffList();

	ChannelDesc *channel;
	TQPtrList<ChannelDesc> *chandesc;
	bool mode;
	TQString orgName;
	int chanNum;

};

#endif /* CHANNELEDITOR_H */
