/*
 * cdcleaner.cpp
 *
 * Copyright (C) 2005 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <tqdir.h>
#include <tqstringlist.h>

#include "cdcleaner.h"



CdCleaner::CdCleaner( const TQString &path )
{
	livePath = path;

	connect( &timer, TQT_SIGNAL(timeout()), this, TQT_SLOT(doClean()) );
	timer.start( 60*1000 );
}



CdCleaner::~CdCleaner()
{
	wait();
}



void CdCleaner::doClean()
{
	start( TQThread::LowestPriority );
}



void CdCleaner::setPath( const TQString &path )
{
	livePath = path;
}



void CdCleaner::run()
{
	TQStringList list;
	TQDir d;

	d.setPath( livePath );
	list = d.entryList( "DVBClient-*.ts", TQDir::Files, TQDir::Name );
	if ( list.count()>1 ) d.remove( list[0] );
}

#include "cdcleaner.moc"
