/*
 * dvbconfig.h
 *
 * Copyright (C) 2004-2007 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef DVBCONFIG_H
#define DVBCONFIG_H

#include <tqspinbox.h>
#include <tqlabel.h>
#include <tqlineedit.h>
#include <tqcombobox.h>
#include <tqtoolbutton.h>
#include <tqbuttongroup.h>
#include <tqlistview.h>
#include <tqcheckbox.h>

#include <kdialogbase.h>
#include <kpushbutton.h>
#include <tdeconfig.h>
#include <tdeio/job.h>
#include <kprogress.h>

#include <linux/dvb/frontend.h>

#define MAX_DEVICES 8

using namespace TDEIO;

class MSpinBox : public TQSpinBox
{
	Q_OBJECT
  
public:
	MSpinBox( TQWidget *parent, int devNum );
public slots:
	void slotValueChanged( int value );
signals:
	void signalValueChanged( int value, int devNum );
private:
	int deviceNumber;
};



class MPushButton : public KPushButton
{
	Q_OBJECT
  
public:
	MPushButton( TQWidget *parent, int devNum, int lnbNum );
private slots:
	void isClicked();
signals:
	void clicked( int devnum, int lnbnum );
private:
	int deviceNumber;
	int lnbNumber;
};



class MCAMButton : public TQPushButton
{
	Q_OBJECT
  
public:
	MCAMButton( TQWidget *parent, int devNum );
private slots:
	void isClicked();
signals:
	void clicked( int devnum );
private:
	int deviceNumber;
};



class MComboBox : public TQComboBox
{
	Q_OBJECT
  
public:
	MComboBox( TQWidget *parent, int devNum, int lnbNum );
private slots:
	void isActivated( int index );
signals:
	void activated( int index, int devnum, int lnbnum );
private:
	int deviceNumber;
	int lnbNumber;
};



class LNB
{
public:
	LNB();

	unsigned int switchFreq;
	unsigned int loFreq;
	unsigned int hiFreq;
	int rotorType;
	double speed13v, speed18v;
	TQStringList source;
	TQValueList<int> position;
	TQString currentSource;
};



class Device
{
public:
	Device( int anum, int tnum, fe_type_t t, const TQString &n, bool as );
	int adapter, tuner;
	fe_type_t type;
	TQString name;
	TQString source;
	int numLnb;
	LNB lnb[4];
	bool canAutoscan;
	int tuningTimeout;
	double usalsLatitude, usalsLongitude;
	bool hasCAM;
	int camMaxService;
	int secMini;
	int secTwice;
	int priority;
	int doS2;
};



class Category
{
public:
	Category( const TQString &tname, const TQString &ticon );
	TQString name;
	TQString icon;
};



class DVBconfig : public TQObject
{
	Q_OBJECT
  

public:

	DVBconfig( const TQString &dvbConf );
	~DVBconfig();
	void readFirst();
	void readConfig();
	void saveConfig();
	int readDvbChanOrder();
	void saveDvbChanOrder( int s, int col );
	void startup();
	static bool haveDvbDevice();
	bool loadDvbData( TQWidget *parent );
	bool localData();
	TQStringList getSourcesList( fe_type_t type );
	bool haveData();
	bool firstRun();
	void addCategory( const TQString &name, const TQString &icon );
	void removeCategory( const TQString &name );
	void changeIconCategory( const TQString &name, const TQString &icon );

	TDEConfig *config;
	TQString recordDir, shiftDir, filenameFormat;
	int beginMargin, endMargin, instantDuration, sizeFile;
	TQSize epgSize, scanSize, timerSize;
	TQPtrList<Device> devList;
	TQPtrList<Category> categories;
	TQString allIcon, tvIcon, radioIcon;
	TQString dvbConfigDir;
	TQString dvbConfigIconsDir;
	TQString broadcastAddress;
	int broadcastPort, senderPort;
	int lastChannel;
	TQValueList<int> splitSizes;
	TQString defaultCharset;
	double usalsLatitude, usalsLongitude;
	int probeMfe;
	int ringBufSize;

private:

	KProgressDialog *downProgress;
	bool downloadFinished;

private slots:

	void setDownloadResult( TDEIO::Job *job );
	void setDownloadPercent( TDEIO::Job *job, unsigned long percent );
};



class KaffeineDvbPlugin;
class DvbPanel;

class DvbConfigDialog : public KDialogBase
{
	Q_OBJECT
  

public:

	DvbConfigDialog( DvbPanel *pan, DVBconfig *dc, TQWidget *parent, KaffeineDvbPlugin *p );
	~DvbConfigDialog();
	void setSource( TQComboBox *box, TQString s );

	TQLineEdit *recordDirLe, *shiftDirLe, *broadcastLe, *filenameFormatLe;
	TQSpinBox *beginSpin, *endSpin, *instantDurationSpin, *bportSpin, *sportSpin, *sizeFileSpin;
	MSpinBox *satNumber[MAX_DEVICES];
	TQCheckBox *secMini[MAX_DEVICES], *secTwice[MAX_DEVICES];
	TQCheckBox *doS2[MAX_DEVICES];
	TQComboBox *sat0[MAX_DEVICES];
	TQComboBox *sat1[MAX_DEVICES];
	TQComboBox *sat2[MAX_DEVICES];
	TQComboBox *sat3[MAX_DEVICES];
	MPushButton *src0[MAX_DEVICES];
	MPushButton *src1[MAX_DEVICES];
	MPushButton *src2[MAX_DEVICES];
	MPushButton *src3[MAX_DEVICES];
	MComboBox *rotor0[MAX_DEVICES];
	MComboBox *rotor1[MAX_DEVICES];
	MComboBox *rotor2[MAX_DEVICES];
	MComboBox *rotor3[MAX_DEVICES];
	MPushButton *lnb0[MAX_DEVICES];
	MPushButton *lnb1[MAX_DEVICES];
	MPushButton *lnb2[MAX_DEVICES];
	MPushButton *lnb3[MAX_DEVICES];
	KPushButton *updateBtn, *dumpBtn;
	TQToolButton *recordDirBtn, *shiftDirBtn, *helpNameBtn;
	DVBconfig *dvbConfig;
	TQComboBox *charsetComb;
	TQPtrList<TQSpinBox> timeoutSpin;
	TQPtrList<TQSpinBox> priority;
	TQCheckBox *probeMfe;
	TQSpinBox *ringBufSize;

private slots:

	void fileTemplateHelp();
	void setRecordDir();
	void setShiftDir();
	void satNumberChanged( int value, int devNum );
	void downloadData();
	void setLnb( int devNum, int lnbNum );
	void setRotor( int index, int devNum, int lnbNum );
	void setRotorSources( int devNum, int lnbNum );
	void setUsals();

protected slots:

	virtual void accept();
};



class LnbConfig : public KDialogBase
{
	Q_OBJECT
  

public:

	LnbConfig( LNB *b, TQWidget *parent );

protected slots:

	virtual void accept();
	void setDual( int id );
	void setUniversal();
	void setCBandMono();
	void setCBandMulti();

private:

	TQSpinBox *slof;
	TQSpinBox *lo, *hi, *single, *vertical, *horizontal;
	TQLabel *slofLab, *loLab, *hiLab, *singleLab, *verticalLab, *horizontalLab;
	TQButtonGroup *nLO;
	TQPushButton *univ, *cmono, *cmulti;

	LNB *lnb;
};



class RotorConfig : public KDialogBase
{
	Q_OBJECT
  

public:

	RotorConfig( Device *d, DVBconfig *c, int lnb, TQWidget *parent );

protected slots:

	virtual void accept();

private slots:

	void reset();
	void add();

private:

	TQSpinBox *position;
	TQComboBox *srcComb;
	TQListView *listView;
	TQPushButton *addBtn, *resetBtn;
	TQLineEdit *speed13, *speed18;

	Device *dev;
	int lnbNum;
	DVBconfig *config;
};


#endif /* DVBCONFIG_H */
