/**************************************************************************
*   Copyright (C) 2005 by Jean-Michel Petit                               *
*   jm_petit@laposte.net                                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
***************************************************************************/
#ifndef k9BurnDVD_H
#define k9BurnDVD_H

#include "k9common.h"
#include "k9progress.h"

#include <k9process.h>
#include <tdelocale.h>

/**
@author Jean-Michel PETIT
*/
class k9BurnDVD: public TQObject
{
Q_OBJECT
  
public:
  k9BurnDVD();

  ~k9BurnDVD();
  virtual void setburnDevice( const TQString& _newVal);
  virtual const TQString& getburnDevice();
  virtual TQWidget* getDialog() {return progress;};
  void setworkDir( const TQString& _newVal);
  void setvolId(TQString  _newVal);
  void setUseK3b(bool _newVal);
  void setAutoBurn (bool _newVal);
  void burn();
  void makeIso(TQString _filename);

  void setSpeed(const TQString& _value) { m_speed = _value;}
  
private:
    TQTime *time;
    k9Progress *progress;
    k9Process *proc;
    k9Process *proc2;
    TQString volId;
    float burnSpeed;
    TQString burnDevice;
    TQString lastMsg;
    TQString workDir;
    TQString m_filename;
    bool cancelled;
    bool useK3b;
    bool autoBurn;
    bool iso;
    bool m_cdrkit;
    void burnWithGrowisofs();
    void burnWithGenisoimage();
    void getGenisoimageCmd(k9Process *proc,TQString _fileName,bool _printSize);
    void getWodimCmd(k9Process *proc);

    void burnWithK3b();
    const TQString getImageSize();
    TQString imageSize;
    TQString m_speed;
private slots: // Private slots    
    void growisoStderr(TDEProcess *proc, char *buffer, int buflen);
    void growisoStdout(TDEProcess *proc, char *buffer, int buflen);  
    void mkisoSizeStderr(TDEProcess *proc, char *buffer, int buflen);
    void mkisoSizeStdout(TDEProcess *proc, char *buffer, int buflen);
};

#endif
