//
// C++ Interface: k9menueditor
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef K9MENUEDITOR_H
#define K9MENUEDITOR_H

#include <tqcanvas.h>

/**
	@author Jean-Michel PETIT <k9copy@free.fr>
*/

class k9MenuButton;
class k9MenuEdit;
class k9CanvasSelection;
class k9MenuEditor : public TQCanvasView {
    Q_OBJECT
  

public:
    k9MenuEditor(TQCanvas&, TQWidget* parent=0, const char* name=0, WFlags f=0);
    void clear();

    k9MenuButton* getSelected() ;
    void setMenu(k9MenuEdit *_menu) {
        m_menu=_menu;
    }

    TQCanvasItem* getMoving() const;

    void setMoving(TQCanvasItem* _value);
    TQPtrList< k9MenuButton > *getSelection() ;
    void clearSelection();
    void hideSelection();
protected:
    void contentsMousePressEvent(TQMouseEvent*);
    void contentsMouseMoveEvent(TQMouseEvent*);
    void contentsMouseReleaseEvent(TQMouseEvent* e);
    void updateCursor(TQMouseEvent *e);
    virtual void resizeEvent ( TQResizeEvent * e );
    void addSelection(TQCanvasItem *_item);
    bool isSelected(TQCanvasItem *_item);
    void drawSelection();
signals:
    void status(const TQString&);
    void itemSelected();

private:
    TQCanvasItem* moving;
    TQCanvasRectangle *m_rect;
    TQPoint moving_start;
    k9MenuEdit *m_menu;
    TQPtrList <k9MenuButton> m_selection;
    k9CanvasSelection *m_canvasSelection;
};

#endif
