// vim: set tabstop=4 shiftwidth=4 noexpandtab:
/*
Gwenview - A simple image viewer for TDE
Copyright 2000-2004 Aurlien Gteau
Copyright 2003 Tudor Calin

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/
#ifndef HISTORY_H
#define HISTORY_H

// TQt
#include <tqobject.h>
#include <tqvaluelist.h>

// KDE
#include <kurl.h>

class TDEToolBarPopupAction;
class TDEActionCollection;

typedef TQValueList<KURL> HistoryList;

namespace Gwenview {
class History : public TQObject {
Q_OBJECT
  
	
public:
	History(TDEActionCollection*);
	~History();

signals:
	void urlChanged(const KURL&);

public slots:
	void addURLToHistory(const KURL&);

private:
	TDEToolBarPopupAction* mGoBack;
	TDEToolBarPopupAction* mGoForward;
	HistoryList mHistoryList;
	HistoryList::Iterator mPosition;
	bool mMovingInHistory;
	
private slots:
	void fillGoBackMenu();
	void fillGoForwardMenu();
	void goBack();
	void goForward();
	void goBackTo(int);
	void goForwardTo(int);
};

} // namespace
#endif



