// vim: set tabstop=4 shiftwidth=4 noexpandtab
/*
Gwenview - A simple image viewer for TDE
Copyright 2000-2004 Aurlien Gteau
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/

#include "threadgate.moc"

#include "tsthread/tsthread.h"

namespace Gwenview {

// The trick is simple. This object connects its slot to its signal, then
// emits the signal using emitSignal(), and the slot gets called in the main
// thread. In the main thread the slot does everything that should be done
// in the main thread, and returns the data using the signal/slot reference
// arguments. As the thread is blocked waiting on the signal to finish,
// there's even no need to do any locking.

ThreadGate::ThreadGate() {
	connect( this, TQT_SIGNAL( signalColor( TQColor&, const char* )),
		this, TQT_SLOT( slotColor( TQColor&, const char* )));
}

ThreadGate* ThreadGate::instance() {
	static ThreadGate gate;
	return &gate;
}

TQColor ThreadGate::color( const char* name ) {
	if( name == NULL || name[ 0 ] == '\0' || name[ 0 ] == '#' )
		return TQColor( name );
	// named color ... needs to be created in the main thread
	if( TSThread::currentThread() == TSThread::mainThread())
		return TQColor( name );
	TQColor col;
	TSThread::currentThread()->emitCancellableSignal( this, TQT_SIGNAL( signalColor( TQColor&, const char* )), col, name );
	return col;
}

void ThreadGate::slotColor( TQColor& col, const char* name ) {
	col = TQColor( name );
}

} // namespace
