// vim: set tabstop=4 shiftwidth=4 noexpandtab
/*
Gwenview - A simple image viewer for TDE
Copyright 2000-2004 Aurlien Gteau
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/
#ifndef CACHE_H
#define CACHE_H

// TQt
#include <tqcstring.h>
#include <tqdatetime.h>
#include <tqimage.h>
#include <tqobject.h>
#include <tqtimer.h>
#include <tqvaluelist.h>

// KDE
#include <kurl.h>

// Local
#include "imageframe.h"
#include "libgwenview_export.h"
class TDEConfig;

namespace Gwenview {
class LIBGWENVIEW_EXPORT Cache : public TQObject {
Q_OBJECT
  
public:
	static Cache* instance();
	~Cache();
	void addImage( const KURL& url, const ImageFrames& frames, const TQCString& format, const TQDateTime& timestamp );
	void addFile( const KURL& url, const TQByteArray& file, const TQDateTime& timestamp );
	void addThumbnail( const KURL& url, const TQPixmap& thumbnail, TQSize imagesize, const TQDateTime& timestamp );
	TQDateTime timestamp( const KURL& url ) const;
	TQByteArray file( const KURL& url ) const;
	void getFrames( const KURL& url, ImageFrames* frames, TQCString* format ) const;
	TQPixmap thumbnail( const KURL& url, TQSize& imagesize ) const;
	void setPriorityURL( const KURL& url, bool set );
	void invalidate( const KURL& url );
	void checkThumbnailSize( int size );
	void readConfig(TDEConfig*,const TQString& group);
	void updateAge();
	enum { DEFAULT_MAXSIZE = 16 * 1024 * 1024 }; // 16MiB
private:
	Cache();
	void checkMaxSize();
	class Private;
	Private* d;
};

} // namespace
#endif
