// vim: set tabstop=4 shiftwidth=4 noexpandtab
/*
Gwenview - A simple image viewer for TDE
Copyright 2000-2004 Aurlien Gteau
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/
// TQt
#include <tqdir.h>

// KDE
#include <kdebug.h>
#include <krun.h>
#include <kservice.h>

// Local
#include "externaltoolaction.moc"
namespace Gwenview {

ExternalToolAction::ExternalToolAction(
	TQObject* parent, const KService* service,
	const KURL::List& urls)
: TDEAction(parent)
, mService(service)
, mURLs(urls)
{
	setText(service->name());
	setIcon(service->icon());
	connect(this, TQT_SIGNAL(activated()),
		this, TQT_SLOT(openExternalTool()) );
			
}


void ExternalToolAction::openExternalTool() {
	TQString dir=mURLs.first().directory();
	TQDir::setCurrent(dir);
	
	TQStringList args=KRun::processDesktopExec(*mService, mURLs, true);
	KRun::runCommand(args.join(" "), mService->name(), mService->icon());
}

} // namespace
