/*
Gwenview - A simple image viewer for TDE
Copyright 2006 Aurélien Gâteau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/
#ifndef INPUTDIALOG_H
#define INPUTDIALOG_H   

// KDE
#include <kdialogbase.h>


class KLineEdit;


namespace Gwenview {


/**
 * An input dialog which give access to its line edit
 */
class InputDialog : public KDialogBase {
Q_OBJECT
  
public:
	InputDialog(TQWidget* parent);
	~InputDialog();
	void setLabel(const TQString& label);
	KLineEdit* lineEdit() const;

private slots:
	void updateButtons();

private:
	struct Private;
	Private* d;
};

} // namespace

#endif /* INPUTDIALOG_H */
