%define name fireflies
%define version 2.07

Summary: Fireflies Screensaver
Name: %{name}
Version: %{version}
Release: 1
License: GPL
Group: Amusements/Graphics
URL: http://somewhere.fscked.org/fireflies
Source0: fireflies-%{version}.tar.gz
Patch0: fireflies-configure.patch
BuildRoot:  %{_tmppath}/%{name}-root

%description
An OpenGL 3D screensaver for xscreensaver.  A bunch of fireflies chase a few
baits around the screen, leaving colorful tails which get blown around by the
wind.

%prep
%setup
%patch0 -p1

%build
./configure --with-bindir=/usr/libexec/xscreensaver
make

%install
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -r $RPM_BUILD_ROOT

%post
# add fireflies to the XScreenSaver file
tmpfile=`mktemp /tmp/xrc.XXXXXX`
for file in /usr/lib/X11/app-defaults/XScreenSaver /etc/X11/app-defaults/XScreenSaver; do
    [ -f $file ] || continue
    grep -q 'fireflies' $file && continue
    cp $file $tmpfile
    cat $tmpfile | sed '
/programs:/ a\
  GL:          "Fireflies 3D"   fireflies -root                             \\n\\
' > $file
done
rm $tmpfile

%files
%defattr(-,root,root)
/usr/lib/xscreensaver/fireflies
/usr/share/xscreensaver/config/fireflies.xml

%changelog
* Sat Oct  1 2005 Simon Roberts <lyricnz@hotmail.com>
- Update for 2.06 and FC4

* Wed Apr 18 2003 Matt Perry <guy@somewhere.fscked.org>
- Initial packaging
