// File autogenerated

// declaration include
#include "vpnpluginproxy.h"

// TQt includes
#include <tqmap.h>
#include <tqstring.h>

// TQt D-Bus includes
#include <tqdbusconnection.h>
#include <tqdbusdata.h>
#include <tqdbusdatamap.h>
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusproxy.h>
#include <tqdbusvariant.h>


namespace DBus
{

VPNPluginProxy::VPNPluginProxy(const TQString& service, const TQString& path, TQObject* parent, const char* name)
    : TQObject(parent, name),
      m_baseProxy(new TQT_DBusProxy())
{
    m_baseProxy->setInterface("org.freedesktop.NetworkManager.VPN.Plugin");
    m_baseProxy->setPath(path);
    m_baseProxy->setService(service);

    TQObject::connect(m_baseProxy, TQ_SIGNAL(dbusSignal(const TQT_DBusMessage&)),
                     this,        TQ_SLOT(slotHandleDBusSignal(const TQT_DBusMessage&)));
}

VPNPluginProxy::~VPNPluginProxy()
{
    delete m_baseProxy;
}

void VPNPluginProxy::setConnection(const TQT_DBusConnection& connection)
{
    m_baseProxy->setConnection(connection);
}

bool VPNPluginProxy::Connect(const TQT_DBusDataMap< TQString >& connection, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromStringKeyMap(connection);

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("Connect", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool VPNPluginProxy::NeedSecrets(const TQT_DBusDataMap< TQString >& settings, TQString& setting_name, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromStringKeyMap(settings);

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("NeedSecrets", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;

    if (reply.count() != 1) return false;

    bool ok = false;

    setting_name = reply.front().toString(&ok);
    if (!ok) return false;

    return true;
}

bool VPNPluginProxy::Disconnect(TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    TQT_DBusMessage reply = m_baseProxy->sendWithReply("Disconnect", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool VPNPluginProxy::SetConfig(const TQMap< TQString, TQT_DBusVariant >& config, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromStringKeyMap(TQT_DBusDataMap< TQString >(config));

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("SetConfig", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool VPNPluginProxy::SetIp4Config(const TQMap< TQString, TQT_DBusVariant >& config, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromStringKeyMap(TQT_DBusDataMap< TQString >(config));

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("SetIp4Config", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool VPNPluginProxy::SetIp6Config(const TQMap< TQString, TQT_DBusVariant >& config, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromStringKeyMap(TQT_DBusDataMap< TQString >(config));

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("SetIp6Config", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool VPNPluginProxy::SetFailure(const TQString& reason, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromString(reason);

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("SetFailure", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

void VPNPluginProxy::setDBusProperty(const TQString& name, const TQT_DBusVariant& value, TQT_DBusError& error)
{
    TQT_DBusConnection connection = m_baseProxy->connection();

    TQT_DBusMessage message = TQT_DBusMessage::methodCall(m_baseProxy->service(), m_baseProxy->path(), "org.freedesktop.DBus.Properties", "Set");

    message << TQT_DBusData::fromString(m_baseProxy->interface());
    message << TQT_DBusData::fromString(name);
    message << TQT_DBusData::fromVariant(value);

    connection.sendWithReply(message, &error);
}

TQT_DBusVariant VPNPluginProxy::getDBusProperty(const TQString& name, TQT_DBusError& error) const
{
    TQT_DBusConnection connection = m_baseProxy->connection();

    TQT_DBusMessage message = TQT_DBusMessage::methodCall(m_baseProxy->service(), m_baseProxy->path(), "org.freedesktop.DBus.Properties", "Get");

    message << TQT_DBusData::fromString(m_baseProxy->interface());
    message << TQT_DBusData::fromString(name);

    TQT_DBusMessage reply = connection.sendWithReply(message, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return TQT_DBusVariant();
    if (reply.count() != 1) return TQT_DBusVariant();

    bool ok = false;
    TQT_DBusVariant value = reply.front().toVariant(&ok);
    if (!ok) return TQT_DBusVariant();

    return value;
}

TQ_UINT32 VPNPluginProxy::getState(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("State", error);

    if (error.isValid()) return TQ_UINT32();

    bool ok = false;

    TQ_UINT32 result =  variant.value.toUInt32(&ok);
    if (!ok) {}

    return result;
}

void VPNPluginProxy::slotHandleDBusSignal(const TQT_DBusMessage& message)
{
    if (message.member() == "StateChanged")
    {
        TQ_UINT32 _state = message[0].toUInt32();

        emit StateChanged(_state);
    }
    else if (message.member() == "Config")
    {
        TQMap< TQString, TQT_DBusVariant > _config = message[0].toStringKeyMap().toVariantMap();

        emit Config(_config);
    }
    else if (message.member() == "Ip4Config")
    {
        TQMap< TQString, TQT_DBusVariant > _ip4config = message[0].toStringKeyMap().toVariantMap();

        emit Ip4Config(_ip4config);
    }
    else if (message.member() == "Ip6Config")
    {
        TQMap< TQString, TQT_DBusVariant > _ip6config = message[0].toStringKeyMap().toVariantMap();

        emit Ip6Config(_ip6config);
    }
    else if (message.member() == "LoginBanner")
    {
        TQString _banner = message[0].toString();

        emit LoginBanner(_banner);
    }
    else if (message.member() == "Failure")
    {
        TQ_UINT32 _reason = message[0].toUInt32();

        emit Failure(_reason);
    }
}

}; // namespace DBus

#include "vpnpluginproxy.moc"

// End of File

