// File autogenerated

// declaration include
#include "mediacontrol1Proxy.h"

// TQt D-Bus includes
#include <tqdbusconnection.h>
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusobjectpath.h>
#include <tqdbusproxy.h>
#include <tqdbusvariant.h>


namespace org
{
namespace bluez
{

MediaControl1Proxy::MediaControl1Proxy(const TQString& service, const TQString& path, TQObject* parent, const char* name)
    : TQObject(parent, name),
      m_baseProxy(new TQT_DBusProxy())
{
    m_baseProxy->setInterface("org.bluez.MediaControl1");
    m_baseProxy->setPath(path);
    m_baseProxy->setService(service);

}

MediaControl1Proxy::~MediaControl1Proxy()
{
    delete m_baseProxy;
}

void MediaControl1Proxy::setConnection(const TQT_DBusConnection& connection)
{
    m_baseProxy->setConnection(connection);
}

bool MediaControl1Proxy::Play(TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    TQT_DBusMessage reply = m_baseProxy->sendWithReply("Play", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool MediaControl1Proxy::Pause(TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    TQT_DBusMessage reply = m_baseProxy->sendWithReply("Pause", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool MediaControl1Proxy::Stop(TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    TQT_DBusMessage reply = m_baseProxy->sendWithReply("Stop", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool MediaControl1Proxy::Next(TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    TQT_DBusMessage reply = m_baseProxy->sendWithReply("Next", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool MediaControl1Proxy::Previous(TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    TQT_DBusMessage reply = m_baseProxy->sendWithReply("Previous", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool MediaControl1Proxy::VolumeUp(TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    TQT_DBusMessage reply = m_baseProxy->sendWithReply("VolumeUp", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool MediaControl1Proxy::VolumeDown(TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    TQT_DBusMessage reply = m_baseProxy->sendWithReply("VolumeDown", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool MediaControl1Proxy::FastForward(TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    TQT_DBusMessage reply = m_baseProxy->sendWithReply("FastForward", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool MediaControl1Proxy::Rewind(TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    TQT_DBusMessage reply = m_baseProxy->sendWithReply("Rewind", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

void MediaControl1Proxy::setDBusProperty(const TQString& name, const TQT_DBusVariant& value, TQT_DBusError& error)
{
    TQT_DBusConnection connection = m_baseProxy->connection();

    TQT_DBusMessage message = TQT_DBusMessage::methodCall(m_baseProxy->service(), m_baseProxy->path(), "org.freedesktop.DBus.Properties", "Set");

    message << TQT_DBusData::fromString(m_baseProxy->interface());
    message << TQT_DBusData::fromString(name);
    message << TQT_DBusData::fromVariant(value);

    connection.sendWithReply(message, &error);
}

TQT_DBusVariant MediaControl1Proxy::getDBusProperty(const TQString& name, TQT_DBusError& error) const
{
    TQT_DBusConnection connection = m_baseProxy->connection();

    TQT_DBusMessage message = TQT_DBusMessage::methodCall(m_baseProxy->service(), m_baseProxy->path(), "org.freedesktop.DBus.Properties", "Get");

    message << TQT_DBusData::fromString(m_baseProxy->interface());
    message << TQT_DBusData::fromString(name);

    TQT_DBusMessage reply = connection.sendWithReply(message, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return TQT_DBusVariant();
    if (reply.count() != 1) return TQT_DBusVariant();

    bool ok = false;
    TQT_DBusVariant value = reply.front().toVariant(&ok);
    if (!ok) return TQT_DBusVariant();

    return value;
}

bool MediaControl1Proxy::getConnected(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Connected", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

TQT_DBusObjectPath MediaControl1Proxy::getPlayer(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Player", error);

    if (error.isValid()) return TQT_DBusObjectPath();

    bool ok = false;

    TQT_DBusObjectPath result =  variant.value.toObjectPath(&ok);
    if (!ok) {}

    return result;
}

}; // namespace bluez

}; // namespace org

#include "mediacontrol1Proxy.moc"

// End of File

