// Copyright (c) 2002-2003 Rob Kaper <cap@capsi.com>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License version 2.1 as published by the Free Software Foundation.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this library; see the file COPYING.LIB.  If not, write to
// the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.

#ifndef LIBATLANTIC_CORE_H
#define LIBATLANTIC_CORE_H

#include <tqobject.h>
#include <tqptrlist.h>

#include "libatlantic_export.h"

class Player;
class ConfigOption;
class Estate;
class EstateGroup;
class Game;
class Trade;
class Auction;

class LIBATLANTIC_EXPORT AtlanticCore : public TQObject
{
TQ_OBJECT
  

public:
	AtlanticCore(TQObject *parent, const char *name);

	void reset(bool deletePermanents = false);

	bool selfIsMaster() const;

	void setPlayerSelf(Player *player);
	Player *playerSelf();

	TQPtrList<Player> players();
	Player *newPlayer(int playerId, const bool &playerSelf = false);
	Player *findPlayer(int playerId);
	void removePlayer(Player *player);

	TQPtrList<Game> games();
	Game *newGame(int gameId, const TQString &type = TQString());
	Game *findGame(const TQString &type); // finds game types
	Game *findGame(int gameId); // finds actual games
	Game *gameSelf();
	void removeGame(Game *game);
	void emitGames();

	TQPtrList<Estate> estates();
	Estate *newEstate(int estateId);
	Estate *findEstate(int estateId);
	Estate *estateAfter(Estate *estate);

	TQPtrList<EstateGroup> estateGroups();
	EstateGroup *newEstateGroup(int groupId);
	EstateGroup *findEstateGroup(int groupId);

	TQPtrList<Trade> trades();
	Trade *newTrade(int tradeId);
	Trade *findTrade(int tradeId);
	void removeTrade(Trade *trade);

	TQPtrList<Auction> auctions();
	Auction *newAuction(int auctionId, Estate *estate);
	void delAuction(Auction *auction);

	ConfigOption *newConfigOption(int configId);
	void removeConfigOption(ConfigOption *configOption);
	ConfigOption *findConfigOption(int configId);

	void printDebug();

signals:
	void createGUI(Player *player);
	void removeGUI(Player *player);
	void createGUI(Game *game);
	void removeGUI(Game *game);
	void createGUI(Trade *trade);
	void removeGUI(Trade *trade);
	void createGUI(ConfigOption *configOption);
	void removeGUI(ConfigOption *configOption);

private:
	Player *m_playerSelf;
	TQPtrList<Player> m_players;
	TQPtrList<Game> m_games;
	TQPtrList<Estate> m_estates;
	TQPtrList<EstateGroup> m_estateGroups;
	TQPtrList<Trade> m_trades;
	TQPtrList<Auction> m_auctions;
	TQPtrList<ConfigOption> m_configOptions;
};

#endif
